/*Synthetic buttons for outline windows.*/

#ifdef MACVERSION 
#include <standard.h>
#endif

#ifdef WIN95VERSION 
#include "standard.h"
#endif

#include "shell.h"
#include "lang.h"
#include "oplist.h"
#include "strings.h"
#include "langxml.h"
#include "processinternal.h"
#include "ops.h"
#include "opbuttons.h"


void opbuttonsattach (hdlwindowinfo hinfo, hdlhashtable htable) {

	/*
	7.1b18 PBS: attach buttons to this outline.
	*/

	hdlhashnode hn;
	short ct = 0;

	(**hinfo).flhidebuttons = false;

	(**hinfo).flsyntheticbuttons = true;

	opnewlist (&(hdllistrecord) (**hinfo).buttonlist, false);

	/*loop through all of the items in the table*/
	
	for (hn = (**htable).hfirstsort; hn != nil; hn = (**hn).sortedlink) {

		bigstring bsname;

		ct++;

		if (ct > 16) /*16 is max number of buttons*/
			break;

		gethashkey (hn, bsname);
		
		xmlgetname (bsname);

		oppushstring ((hdllistrecord) (**hinfo).buttonlist, nil, bsname);
		} /*for*/

	(**hinfo).buttonscripttable = (Handle) htable;
	} /*opbuttonsattach*/


boolean opbuttonstatus (short buttonnum, tybuttonstatus *status) {

	/*
	7.1b18 PBS: buttons are always displayed and enabled.
	*/
	
	if (outlinedata == NULL)
		return (false);

	(*status).flenabled = true;
	
	(*status).fldisplay = true;
	
	(*status).flbold = false; /*our buttons are never bold*/
	
	return (true);
	} /*opbuttonstatus*/


boolean opbutton (short buttonnum) {
	
	/*
	7.1b18 PBS: Handle a click in an outline button. Run
	the associated script.
	*/
	
	hdlhashtable ht = (hdlhashtable) (**shellwindowinfo).buttonscripttable;
	hdlhashnode hn;
	hdltreenode hcode;
	tyvaluerecord v;
	short ct = 0;

	/*Find the item in the table and call the script.*/
	
	for (hn = (**ht).hfirstsort; hn != nil; hn = (**hn).sortedlink) {

		ct++;

		if (ct > 16) /*16 is max number of buttons*/
			break;

		if (ct == buttonnum) {
		
			langcompilescript (hn, &hcode);

			langexternalvaltocode ((**hn).val, &hcode);

			langruncode (hcode, nil, &v);

			disposevaluerecord (v, false);

			break;
			} /*if*/		
		} /*for*/

	return (true);
	} /*scriptbutton*/
